<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {

        if (Schema::hasColumn('releases', 'status')) {
            Schema::table('releases', function (Blueprint $table) {
                $table->dropColumn('status');
            });
        }

        
        Schema::table('releases', function (Blueprint $table) {
            $table->boolean('status')->default(false)->after('updated_by');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('releases', function (Blueprint $table) {
            $table->dropColumn('status');
        });
    }
};
